unit fCSched;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, ORCtrls, ORNet, ORFn, ExtCtrls;

type
  TfrmCSched = class(TForm)
    btnExit: TBitBtn;
    hcCSched: THeaderControl;
    lbTemp: TListBox;
    lbCSched: TORListBox;
    pnl1: TPanel;
    btnDet: TButton;
    btnPrint: TButton;
    Button3: TButton;
    lbPTemp: TORListBox;
    procedure lbCSchedDblClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure btnDetClick(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
    procedure RefreshSched;
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure lbCSchedClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmCSched: TfrmCSched;
  Title: string;

procedure CurrentSchedule;

implementation

{$R *.dfm}

uses SCMMain, fWait, fRptBox, fGenPrint, rLocal;

procedure CurrentSchedule;
begin
  frmCSched := TfrmCSched.Create(Application);
  try
  with frmCSched do
    begin
      Title := Caption + SpecName;
      btnDet.Enabled := False;
      RefreshSched;
      ShowModal;
    end;
  finally
    frmCSched.Release;
  end;
end;

procedure TfrmCSched.lbCSchedDblClick(Sender: TObject);
var
  opcase: string;
begin
  ResetTimeOut;
  opcase := piece(lbCSched.Items[lbCSched.ItemIndex], '^', 7);
  CallV('APTWL GET REQ DETAIL', [opcase]);
  ReportBox(RPCBrokerV.Results, 'Surgery Case Detail', True);
end;

procedure TfrmCSched.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmCSched.btnDetClick(Sender: TObject);
begin
  lbCSchedDblClick(Self);
end;

procedure TfrmCSched.btnPrintClick(Sender: TObject);
var
  Title: string;
  J: integer;
begin
  lbPTemp.Items.Clear;
  for J := 0 to hcCSched.Sections.Count do lbPTemp.Items.Add(hcCSched.Sections[J].Text);
  Title := frmCSched.Caption;
  GenPrint(lbCSched, Title, lbCSched.Pieces, lbCSched.TabPositions, lbPTemp);
end;

procedure TfrmCSched.RefreshSched;
var
  Count, J: integer;
begin
  CallV('APTWL GET CURRENT SCHED', [SpecIFN]);
  lbCSched.Items := RPCBrokerV.Results;
  Count := lbCSched.Items.Count;
  if piece(lbCSched.Items[0], '^', 1) = '*' then Count := 0;
  for J := 0 to lbCSched.Items.Count -1 do
    begin
      if piece(lbCSched.Items[J], '^', 1) = '----------' then Count := Count -1;
    end;
  frmCSched.Caption := Title + '  (' + IntToStr(Count) + ')';
end;

procedure TfrmCSched.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  ResetTimeOut;
end;

procedure TfrmCSched.lbCSchedClick(Sender: TObject);
begin
  btnDet.Enabled := True;
end;

end.
